package gov.va.med.mhv.sm.web.smActions;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

import gov.va.med.mhv.foundation.service.response.CollectionServiceResponse;
import gov.va.med.mhv.foundation.service.response.ServiceResponse;
import gov.va.med.mhv.sm.dto.DiagnosisDTO;
import gov.va.med.mhv.sm.dto.LocationDssUnitsDTO;
import gov.va.med.mhv.sm.dto.PatientEligibilityClassifications;
import gov.va.med.mhv.sm.enumeration.ParticipantTypeEnum;
import gov.va.med.mhv.sm.enumeration.SystemFolderEnum;
import gov.va.med.mhv.sm.enumeration.UserTypeEnum;
import gov.va.med.mhv.sm.enumeration.WorkloadCaptureTypeEnum;
import gov.va.med.mhv.sm.model.Clinician;
import gov.va.med.mhv.sm.model.Message;
import gov.va.med.mhv.sm.model.SMClinicsTriageMap;
import gov.va.med.mhv.sm.model.SMWorkloadHistorical;
import gov.va.med.mhv.sm.model.TiuNotePreview;
import gov.va.med.mhv.sm.model.TriageGroup;
import gov.va.med.mhv.sm.model.User;
import gov.va.med.mhv.sm.service.AdminService;
import gov.va.med.mhv.sm.service.TiuNoteService;
import gov.va.med.mhv.sm.service.TriageGroupService;
import gov.va.med.mhv.sm.service.response.messages.SmsServiceMessages;
import gov.va.med.mhv.sm.web.form.WorkloadForm;
import gov.va.med.mhv.sm.util.WorkloadUtil;
import gov.va.med.mhv.sm.wsclient.adminqueriessvc.SMNoteTitle;
import gov.va.med.mhv.sm.wsclient.tiusvc.DSSUnit;
import gov.va.med.mhv.sm.wsclient.tiusvc.Diagnosis;
import gov.va.med.mhv.sm.wsclient.tiusvc.ECSProcedure;
import gov.va.med.mhv.sm.wsclient.tiusvc.PatientClassifications;
import gov.va.med.mhv.sm.wsclient.tiusvc.PatientEligibility;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SMCPRSNotesWorkloadAction extends ReadMessage{

	private static final long serialVersionUID = 5827380152926892019L;

	private static final Log log = LogFactory.getLog(SMCPRSNotesWorkloadAction.class);

	private static final String CLINICIAN_READ_MESSAGE = "CLINICIAN_READ_MESSAGE";
	private static final String CURRENT_READ_MESSAGE = "sessionMessage";
	private static String STRUTS_RESULT;
	private static String STRUTS_RESULT_REFRESH_INBOX="REFRESHINBOX";
	private static String STRUTS_RESULT_INBOX="inbox";
	private static String STRUTS_RESULT_DRAFTS="drafts";
	private final static String STRUTS_RESULT_WORKLOAD="workload";
	private final static String STRUTS_RESULT_HISTORICAL="historical";
	private final static String STRUTS_RESULT_SAVE = "save";
	private final static String STRUTS_RESULT_CHANGECLINIC="changeClinicAndTitle";
	private final static String STRUTS_RESULT_PROBLEM_LIST="problemList";

	private final static String STRUTS_RESULT_WLC_SUCCESS="saveProgressNoteAfterWLC";
	private final static String STRUTS_RESULT_WLC_ERROR="wlcSaveError";
	private final static String STRUTS_RESULT_CPRS_NOTES_SUCCESS="progressNoteSuccess";
	private final static String STRUTS_RESULT_CHECKBOX_ERROR="checkBoxError";

    private final static String PROGRESS_NOTES_CLINIC_SUCCESSFUL="Your request to save the message in CPRS has been sent.</br> If this message fails to save, you will receive a notification in the CPRS Progress Notes Alerts folder.";
	//private final static String PROGRESS_NOTES_CLINIC_SUCCESSFUL="Your request to save the message in CPRS is queued. The message will be linked with SM Clinic: ";
	private final static String DEFAULT_SM_CLINIC = "SECURE MESSAGING";
	private final static String DEFAULT_CPRS_NOTE_TITLE = "SECURE MESSAGING";
	private final static String SESSION_DSS_UNITS_MAP="dssUnitsMap";
	public final static String SESSION_DSS_UNIT="dssUnit";
	public final static String SESSION_PROCEDURE="procedure";
	public final static String SESSION_PRIMARY_DIAGNOSIS="primaryDiagnosis";
	public final static String SESSION_SECONDARY_DIAGNOSIS1="secondaryDiagnosis1";
	public final static String SESSION_SECONDARY_DIAGNOSIS2="secondaryDiagnosis2";
	public final static String SESSION_SECONDARY_DIAGNOSIS3="secondaryDiagnosis3";
	public final static String SESSION_SECONDARY_DIAGNOSIS4="secondaryDiagnosis4";
	public final static String SESSION_PRIMARY_PROVIDER="primaryProvider";
	public final static String SESSION_ELIGIBILITY="eligibility";
	public final static String SESSION_PATIENT_CLASSIFICATION="patientClassification";
	public final static String SESSION_SELECTED_MESSAGES_IN_THREAD="selectedMessagesInThread";

	private final static String SESSION_PROCEDURE_MAP="procedureMap";
	private final static String SESSION_ELIGIBILITY_MAP="eligibilityMap";
	private final static String SESSION_PROBLEM_LIST_MAP="problemListMap";
	private final static String SESSION_DIAGNOSIS_MAP = "diagnosisMap";
	private final static String DIAGNOSIS_POPUP="diagnosisPopup";
	public  final static String CAPTURE_HEADER="captureHeader";
	private final static String WORKLOAD_CAPTURE_HEADER="Workload Credit Form";
	private final static String HISTORICAL_CAPTURE_HEADER="Record Increment of Time Form";
	private static String WHICH_DIAGNOSIS="whichDiagnosis";
	private static String PRIMARY="primary";
	private static String SECONDARY1="secondary1";
	private static String SECONDARY2="secondary2";
	private static String SECONDARY3="secondary3";
	private static String SECONDARY4="secondary4";
	

	private AdminService adminService;
	private TriageGroupService triageGroupService;
	private Collection cprsTitles;
	private Map providerClinics;
	private Map dssUnits;
	private Map procedureNamesMap;
	private Map eligibilityMap;
	private Map providersList;
	private Map problemListMap;
	private Map diagnosisMap;

	private String changeProcedure;
	private String changeClinic;
	private String defaultClinic;
	private String defaultTitle;
	private String selectClinicAndTitle;
	private String cancelClinicAndTitle;
	private String clinicIen;
	private String noteTitle;

	private String workloadType;

	private String locationIen;
	private String defaultEligibility;

	private WorkloadForm workloadForm;
	private String dssUnitSelect;
	private String procedureSelect;
	private String eligibilitySelect;
	private String primarySelect;
	private String problemList;
	private String problemListSelectSubmit;
	private String diagnosisSearchSubmit;
	private String dianosisSelectSubmit;
	private String primarySearch;
	private String searchDiagnosis;
	private boolean visitRelatedTo=false;
	private boolean changeDssEnabled=true;
	private boolean changeEligibilityEnabled=true;
	private boolean progressNotesStatus;
	

	public void prepare() throws Exception {
		super.prepare();
		WebApplicationContext ctx = WebApplicationContextUtils
		.getWebApplicationContext(ServletActionContext
				.getServletContext());
		adminService = (AdminService) ctx.getBean("adminService");
		triageGroupService = (TriageGroupService) ctx.getBean("triageGroupService");
		setDssUnits(new HashMap<String,String>());
		setProcedureNamesMap(new HashMap());
		setEligibilityMap(new HashMap());
		setDiagnosisMap(new HashMap());
		setProvidersList(sortByValue(getSortedProviders()));
	}

	private Map getSortedProviders(){
		HashMap providersMap = new HashMap();
		TriageGroup tg = triageGroupService.findTriageGroupById(getCurrentMessage().getThread().getMailGroup().getId()).getPayload();
		triageGroupService.getCliniciansForTriageGroup(tg);
		for(Clinician clinician:tg.getClinicians()){
			providersMap.put(clinician.getDuz(),clinician.getName());
		}
		return providersMap;
	}

	public static String getAttachmentNames(Message message){

		WebApplicationContext ctx = WebApplicationContextUtils
		.getWebApplicationContext(ServletActionContext
				.getServletContext());
		TiuNoteService tiuNoteService = (TiuNoteService)ctx.getBean("tiuNoteService");
		String attachmentNames = tiuNoteService.getAttachmentNames(message);
		if(log.isInfoEnabled()){
			log.info("MessageId:"+message.getId()+"^Attachment Names with Workload Messages..."+attachmentNames);
		}

		return attachmentNames;
	}

    public String saveMessageAsTIU() {

    	setSessionAttribute(SESSION_SELECTED_MESSAGES_IN_THREAD, null);
        User u = (User) getRequest().getSession().getAttribute(CURRENT_USER);
        TiuNotePreview notePreview = (TiuNotePreview) getRequest().getSession().getAttribute("notePreview");
        if (u == null || !u.getUserType().equals(UserTypeEnum.CLINICIAN)) {
                        return ERROR;
        }

        	Message message = (Message) getRequest().getSession().getAttribute(CURRENT_MESSAGE);

        	if (getRequest().getParameterMap().containsKey("save") || getRequest().getParameterMap().containsKey("append"))
        	{
        		if(getSelectedMessages()==null)
        		{
					getRequest().getSession().setAttribute("CHECKBOX_ERROR","CheckBoxNotSelected");
					setSessionAttribute(SESSION_SELECTED_MESSAGES_IN_THREAD, null);
					return "CLINICIAN_INPUT";
				}else{
					if(getSelectedMessages()!=null && getSelectedMessages().length==1){
						if(getSelectedMessages()[0].equalsIgnoreCase("All")){
							getRequest().getSession().setAttribute("CHECKBOX_ERROR","CheckBoxNotSelected");
							setSessionAttribute(SESSION_SELECTED_MESSAGES_IN_THREAD, null);
							return "CLINICIAN_INPUT";
						}
					}
				}
        				 ServiceResponse<Boolean> response = null;
						 if(message.getAssignedTo()== null){
						    message.setAssignedTo((Clinician)u);
						    response = getMessageService().assignMessage(message,(Clinician)u,(Clinician)u);
						    if(handleMessages(response)){
						    	if(log.isErrorEnabled()){
						    		log.error("Error while trying to assign a message to a Clinician in saveMessageAsTIU()");
						    	}
						    }
						 }


						 response = getTiuNoteService().createProgressNoteSMWeb(message.getThread(),(Clinician) u, getSelectedMessages(),notePreview);
						 
						 if(!notePreview.isNewMessage()){
							 setupBean(message);
						 }

                        if (handleMessages(response)){
                                        getRequest().setAttribute("TIU_ERRORS", Boolean.TRUE);
                                        return notePreview(message, (Clinician)u);
                        }else{
                        				addActionError(PROGRESS_NOTES_CLINIC_SUCCESSFUL);
                        				//addActionError(PROGRESS_NOTES_CLINIC_SUCCESSFUL+notePreview.getClinicName()+", CPRS Title: "+notePreview.getCprsTitle()+".");
                                        if(notePreview.isNewMessage()){
                                        	//return STRUTS_RESULT_REFRESH_INBOX;
                                        	if(getCurrentFolder().getId().equals(SystemFolderEnum.DRAFTS.getId())){
                                        		setProgressNotesStatus(true);
                                				return STRUTS_RESULT_DRAFTS;
                                        	}
                                        	return STRUTS_RESULT_INBOX;
                                        }
                                        else{
                                        	 Message currentReadMessage = (Message)getSession().getAttribute(CURRENT_READ_MESSAGE);
                                 	         if(currentReadMessage!=null){
                                 	        	currentReadMessage= getMessageService().findMessageById(currentReadMessage.getId());
                                 	        	getSession().setAttribute(AbstractInboxAction.CURRENT_MESSAGE, currentReadMessage);
                                 	        	return SUCCESS;	
                                 	        }
                                        }
                                        return SUCCESS;
                        }
        	}else if (getRequest().getParameterMap().containsKey("cancel"))
        	{
        			if(notePreview.isNewMessage()){
        				if(getCurrentFolder().getId().equals(SystemFolderEnum.DRAFTS.getId())){
        					setProgressNotesStatus(false);
        					return STRUTS_RESULT_DRAFTS;
        				}else{
        					return STRUTS_RESULT_INBOX;
        				}
        			}
        		 	setupBean(message);
        		 	setSessionAttribute(SESSION_SELECTED_MESSAGES_IN_THREAD, null);
        		 	return  STRUTS_RESULT_REFRESH_INBOX;
        	}else if (getRequest().getParameterMap().containsKey("changeClinic")) {
        			    return changeClinicAndTitles();
        	}
        	else if(getRequest().getParameterMap().containsKey("selectClinicAndTitle")){
        				return selectedClinicAndTitle();
        	}
        	else if(getRequest().getParameterMap().containsKey("workload")){
        				if(getSelectedMessages()==null)
        				{
        					return checkBoxError();
        				}else{
        					if(getSelectedMessages()!=null && getSelectedMessages().length==1){
        						if(getSelectedMessages()[0].equalsIgnoreCase("All")){
        							return checkBoxError();
        						}
        					}
        					getSession().setAttribute(CAPTURE_HEADER,WORKLOAD_CAPTURE_HEADER);
        					setWorkloadType(WorkloadCaptureTypeEnum.WORKLOAD_CREDIT.getId().toString());
        					return captureWorkloadForm();
        				}
        	}
        	else if(getRequest().getParameterMap().containsKey("historical")){
        				if(getSelectedMessages()==null)
        				{
        					return checkBoxError();
        				}else{
        					if(getSelectedMessages()!=null && getSelectedMessages().length==1){
        						if(getSelectedMessages()[0].equalsIgnoreCase("All")){
        							return checkBoxError();
        						}
        					}
        					getSession().setAttribute(CAPTURE_HEADER,HISTORICAL_CAPTURE_HEADER);
        					setWorkloadType(WorkloadCaptureTypeEnum.HISTORICAL_NOTE.getId().toString());
        					return captureWorkloadForm();
        				}

        	}
        	else
        	{
                        return notePreview(message, (Clinician)u);
        	}
     }

    public String checkBoxError(){
    	setSessionAttribute("CHECKBOX_ERROR","CheckBoxNotSelected");
    	setSessionAttribute(SESSION_SELECTED_MESSAGES_IN_THREAD, null);
    	return STRUTS_RESULT_CHECKBOX_ERROR;
    }

    public String captureWorkloadForm(){
    	getSession().setAttribute(SESSION_SELECTED_MESSAGES_IN_THREAD, getSelectedMessages());
    	TiuNotePreview notePreview = (TiuNotePreview) getRequest().getSession().getAttribute("notePreview");
    	notePreview.setProcedureDateTime(new Date());
    	notePreview.setSelectedMessages(getSelectedMessages());
    	getSession().setAttribute("notePreview", notePreview);
    	setClinicIen(notePreview.getClinicIen());
    	removeAllSessionAttribute();

    	Map<String,String> dssUnitsMap = sortByValue(getDSSUnitsBySMClinic());
    	setDssUnits(dssUnitsMap);
    	setSessionAttributeMap(SESSION_DSS_UNITS_MAP,dssUnitsMap);
    	if(dssUnitsMap.size()==1){  //If there is only one dss unit, pre-select the dss units.
    		for (Map.Entry<String, String> entry : dssUnitsMap.entrySet()){
    			if(getWorkloadForm()==null){workloadForm = new WorkloadForm();}
    				workloadForm.setDssUnitIen(entry.getKey());
    				setChangeDssEnabled(false);
    		}
    		return selectProcedure();
    	}
    	return STRUTS_RESULT_WORKLOAD;
    }

    public String changeDSSUnit(){
    	removeSessionMaps();
    	removeSessionAttribute(SESSION_DSS_UNIT);
    	removeSessionAttribute(SESSION_PROCEDURE);
    	removeSessionAttribute(SESSION_ELIGIBILITY);
    	removeSessionAttribute(SESSION_PATIENT_CLASSIFICATION);
    	setVisitRelatedTo(false);
    	resetPatientDemoGraphics();

    	Map<String, String> dssUnitsMap = sortByValue(getDSSUnitsBySMClinic());
    	setDssUnits(dssUnitsMap);
    	setSessionAttributeMap(SESSION_DSS_UNITS_MAP,dssUnitsMap);
    	return STRUTS_RESULT_WORKLOAD;
    }

    public String changeProcedure(){
    	 removeSessionMaps();
    	 removeSessionAttribute(SESSION_PROCEDURE);
    	 removeSessionAttribute(SESSION_ELIGIBILITY);
    	 removeSessionAttribute(SESSION_PATIENT_CLASSIFICATION);
    	 setVisitRelatedTo(false);
    	 resetPatientDemoGraphics();

    	 Map<String, String> procedureMap = getECSProceduresByDSSAndLocation();
     	 setProcedureNamesMap(procedureMap);
     	 setSessionAttributeMap(SESSION_PROCEDURE_MAP,procedureMap);
     	 return STRUTS_RESULT_WORKLOAD;
    }

    public String changeEligibility(){
    	removeSessionMaps();
   	 	removeSessionAttribute(SESSION_ELIGIBILITY);
   	 	setVisitRelatedTo(false);
   	 	resetPatientDemoGraphics();
    	Map<String, String> eligibiltyMap = getPatientEligibility();
    	setEligibilityMap(eligibiltyMap);
    	setSessionAttributeMap(SESSION_ELIGIBILITY_MAP,eligibiltyMap);
    	return STRUTS_RESULT_WORKLOAD;
   }


    public String changeDiagnosis(){
    	String changeDiagnosis = getRequest().getParameter("changeDiagnosis");
    	if(changeDiagnosis.equalsIgnoreCase("primary")) removeSessionAttribute(SESSION_PRIMARY_DIAGNOSIS);
    	else if(changeDiagnosis.equalsIgnoreCase("secondary1")) removeSessionAttribute(SESSION_SECONDARY_DIAGNOSIS1);
    	else if(changeDiagnosis.equalsIgnoreCase("secondary2")) removeSessionAttribute(SESSION_SECONDARY_DIAGNOSIS2);
    	else if(changeDiagnosis.equalsIgnoreCase("secondary3")) removeSessionAttribute(SESSION_SECONDARY_DIAGNOSIS3);
    	else if(changeDiagnosis.equalsIgnoreCase("secondary4")) removeSessionAttribute(SESSION_SECONDARY_DIAGNOSIS4);
    	return STRUTS_RESULT_WORKLOAD;
    }


    // This is method calls, when the user click on Select
    public String workload(){

    	if(getDssUnitSelect()!=null)  // If the user clicked on DSS Select
    	{
    		if(workloadForm.getDssUnitIen().equals("-1")){
    			addFieldError("workloadFormError","Please select a DSS Unit.");
    			return changeDSSUnit();
    		}
    		return selectProcedure();
    	}

    	if(getProcedureSelect()!=null) // If the user clicked on Procedure Select
    	{
    		if(workloadForm.getProcedureIen().equals("-1")){
    			addFieldError("workloadFormError","Please select a Procedure Name.");
    			return changeProcedure();
    		}

    		if(getSession().getAttribute(CAPTURE_HEADER).equals("Workload Credit Form"))
    		{
    			return selectEligibility();
    		}
    		else
    		{
    			Map procedureMap = (Map)getSession().getAttribute(SESSION_PROCEDURE_MAP);
    	    	setSessionAttribute(SESSION_PROCEDURE,WorkloadUtil.getNameWithIen(workloadForm.getProcedureIen(),procedureMap.get(workloadForm.getProcedureIen()).toString()));
    	    	removeSessionAttribute(SESSION_PROCEDURE_MAP);
    	    	return STRUTS_RESULT_WORKLOAD;
    		}
    	}

    	if(getEligibilitySelect()!=null) // If the user clicked on Procedure Select
    	{
    		String eligibility = getRequest().getParameter("workloadForm.eligibilityIen");
    		if(eligibility==null){
    			addFieldError("workloadFormError","Please select a Eligibility Code.");
    			return changeEligibility();
    		}
    		return selectDemographics();
    	}


    	if(getPrimarySelect()!=null) // If the user clicked on Primary Problem List button;
    	{
    		setSessionAttribute(WHICH_DIAGNOSIS, PRIMARY);
    		return loadProblemList();
    	}

    	if(getRequest().getParameterMap().containsKey("secondarySelect1"))
    	{
    		setSessionAttribute(WHICH_DIAGNOSIS,SECONDARY1);
    		return loadProblemList();
    	}

    	if(getRequest().getParameterMap().containsKey("secondarySelect2"))
    	{
    		setSessionAttribute(WHICH_DIAGNOSIS,SECONDARY2);
    		return loadProblemList();
    	}

    	if(getRequest().getParameterMap().containsKey("secondarySelect3"))
    	{
    		setSessionAttribute(WHICH_DIAGNOSIS,SECONDARY3);
    		return loadProblemList();
    	}

    	if(getRequest().getParameterMap().containsKey("secondarySelect4"))
    	{
    		setSessionAttribute(WHICH_DIAGNOSIS,SECONDARY4);
    		return loadProblemList();
    	}

    	if(getProblemListSelectSubmit()!=null)
    	{
    		setSelectedProblemList();
    		return STRUTS_RESULT_WORKLOAD;
    	}

    	// If the user clicked Primary Search Diagnosis button;
    	if(getRequest().getParameterMap().containsKey("primarySearch"))
    	{
    		setSessionAttribute(WHICH_DIAGNOSIS, "primary");
    		return otherDiagnosis();
    	}

    	// If the user clicked Secondary Search Diagnosis1 button;
    	if(getRequest().getParameterMap().containsKey("secondarySearch1"))
    	{
    		setSessionAttribute(WHICH_DIAGNOSIS, SECONDARY1);
    		return otherDiagnosis();
    	}

    	// If the user clicked Secondary Search Diagnosis2 button;
    	if(getRequest().getParameterMap().containsKey("secondarySearch2"))
    	{
    		setSessionAttribute(WHICH_DIAGNOSIS, SECONDARY2);
    		return otherDiagnosis();
    	}
    	// If the user clicked Secondary Search Diagnosis3 button;
    	if(getRequest().getParameterMap().containsKey("secondarySearch3")) // If the user clicked Primary Search Diagnosis button;
    	{
    		setSessionAttribute(WHICH_DIAGNOSIS, SECONDARY3);
    		return otherDiagnosis();
    	}
    	// If the user clicked Secondary Search Diagnosis4 button;
    	if(getRequest().getParameterMap().containsKey("secondarySearch4"))
    	{
    		setSessionAttribute(WHICH_DIAGNOSIS, SECONDARY4);
    		return otherDiagnosis();
    	}

    	if(getDiagnosisSearchSubmit()!=null)
    	{
    		return searchDianosis();

    	}

    	// If the user pressed the Submit Button in the Select Diagnosis page
    	if(getDianosisSelectSubmit()!=null){
    		setSelectedDiagnosis();
    		return STRUTS_RESULT_WORKLOAD;
    	}

    	if(getRequest().getParameterMap().containsKey("primaryProviderSelect")){

    		String[] providerIds = getRequest().getParameterValues("workloadForm.providerId");
    		if(providerIds!=null && providerIds[0]!=null){
    			List clinicianList  = getUserDao().findClinicianByStationAndDuz(((Clinician)getCurrentUser()).getStationNo(),providerIds[0].toString());
    			if(clinicianList!=null && clinicianList.get(0)!=null){
    				Clinician clinician = (Clinician)clinicianList.get(0);
    				setSessionAttribute(SESSION_PRIMARY_PROVIDER,WorkloadUtil.getNameWithIen(clinician.getDuz(),clinician.getName()));
    			}
    		}else{
    			addFieldError("workloadFormError","Please Select a Primary Provider.");
    			return STRUTS_RESULT_WORKLOAD;
    		}
    		return STRUTS_RESULT_WORKLOAD;
    	}


    	// If the user pressed Cancel in problem List page.
    	if(getRequest().getParameterMap().containsKey("problemListSelectCancel") || getRequest().getParameterMap().containsKey("dianosisSelectCancel") || getRequest().getParameterMap().containsKey("diagnosisSearchCancel")){
    		return STRUTS_RESULT_WORKLOAD;
    	}

    	if(getRequest().getParameterMap().containsKey("ecsWorkloadSubmit")){
    		return saveWorkloadECS();
    	}

    	if(getRequest().getParameterMap().containsKey("ecsHistoricalSubmit")){
    		return saveHistoricalECS();
    	}

    	if(getRequest().getParameterMap().containsKey("ecsCancel")){
    		removeAllSessionAttribute();
    		return notePreview(getCurrentMessage(),(Clinician)getCurrentUser());
    	}

    	// When the user click on "OK" to Save Progress Notes attach with visit.
    	if(getRequest().getParameterMap().containsKey("saveProgressNotesSubmit")){

    		return saveProgressNotesWithVisit();
    	}

    	//When the user click on "Cancel" in the workload save error page.
    	if(getRequest().getParameterMap().containsKey("cancelProgressNotes")){

    		return redirectToReadMessage();
    	}


    	return STRUTS_RESULT_WORKLOAD;
    }

    private String saveProgressNotesWithVisit(){
    	TiuNotePreview notePreview = (TiuNotePreview)getSession().getAttribute("notePreview");
    	
    	ServiceResponse<Boolean> response = getTiuNoteService().createProgressNoteWithWLCVisit(getPatientId(), getCurrentUser().getId(), getCurrentMessage().getThread(), notePreview);
    	
    	if(response.getPayload()){
    		addActionError(PROGRESS_NOTES_CLINIC_SUCCESSFUL);
    		if(notePreview.isNewMessage()){
    			removeSessionAttribute("notePreview");
    			if(getCurrentFolder().getId().equals(SystemFolderEnum.DRAFTS.getId())){
    				setProgressNotesStatus(true);
    				return STRUTS_RESULT_DRAFTS;
    			}
    			else{
    				return STRUTS_RESULT_INBOX;
    			}
    		}
    	}
    	else{
    		addActionError("An Error occured while Saving Progress Notes, please try again later.");
    	}
    	setupBean(getCurrentMessage());
    	Message currentReadMessage = (Message)getSession().getAttribute(CURRENT_READ_MESSAGE);
	    if(currentReadMessage!=null){
	        currentReadMessage= getMessageService().findMessageById(currentReadMessage.getId());
	        getSession().setAttribute(AbstractInboxAction.CURRENT_MESSAGE, currentReadMessage);
	    }
    	removeSessionAttribute("notePreview");
        return STRUTS_RESULT_CPRS_NOTES_SUCCESS;
    }

    private String redirectToReadMessage(){
    	removeSessionAttribute("notePreview");
    	setupBean(getCurrentMessage());
        return STRUTS_RESULT_CPRS_NOTES_SUCCESS;
    }



    private String selectProcedure(){
    	Map dssUnitMap = (Map)getSession().getAttribute(SESSION_DSS_UNITS_MAP);
    	setSessionAttribute(SESSION_DSS_UNIT,WorkloadUtil.getNameWithIen(workloadForm.getDssUnitIen(),dssUnitMap.get(workloadForm.getDssUnitIen()).toString()));
    	removeSessionAttribute(SESSION_DSS_UNITS_MAP);
        setProcedureNamesMap(getECSProceduresByDSSAndLocation());
    	setSessionAttributeMap(SESSION_PROCEDURE_MAP,procedureNamesMap);
    	return STRUTS_RESULT_WORKLOAD;
    }

    private String selectEligibility(){

    	Map procedureMap = (Map)getSession().getAttribute(SESSION_PROCEDURE_MAP);
    	setSessionAttribute(SESSION_PROCEDURE,WorkloadUtil.getNameWithIen(workloadForm.getProcedureIen(),procedureMap.get(workloadForm.getProcedureIen()).toString()));
    	removeSessionAttribute(SESSION_PROCEDURE_MAP);
    	setEligibilityMap(getPatientEligibility());
    	setSessionAttributeMap(SESSION_ELIGIBILITY_MAP,getPatientEligibility());

    	if(getEligibilityMap().size()==1){  //If there is only one eligibility, pre-select the eligibility.
    		for (Map.Entry<String, String> entry : getEligibilityMap().entrySet()){
    			workloadForm.setEligibilityIen(entry.getKey());
    			setChangeEligibilityEnabled(false);
    		}
    		return selectDemographics();
    	}
    	return STRUTS_RESULT_WORKLOAD;
    }

    private String selectDemographics(){
    	Map eligibilityMap = (Map)getSession().getAttribute(SESSION_ELIGIBILITY_MAP);
    	setSessionAttribute(SESSION_ELIGIBILITY,WorkloadUtil.getNameWithIen(workloadForm.getEligibilityIen(),eligibilityMap.get(workloadForm.getEligibilityIen()).toString()));
        setVisitRelatedTo(true);
    	return STRUTS_RESULT_WORKLOAD;
    }

    private String captureHistoricalForm(){
    	getSession().setAttribute(SESSION_SELECTED_MESSAGES_IN_THREAD,getSelectedMessages());
    	setWorkloadType(WorkloadCaptureTypeEnum.HISTORICAL_NOTE.getDescription());
    	return STRUTS_RESULT_HISTORICAL;
    }

    private void removeSessionMaps(){
    	removeSessionAttribute(SESSION_DSS_UNITS_MAP);
    	removeSessionAttribute(SESSION_PROCEDURE_MAP);
    	removeSessionAttribute(SESSION_ELIGIBILITY_MAP);
    }

    private void resetPatientDemoGraphics(){
    	 if(workloadForm!=null){
    		 workloadForm.setServiceConnected("");
    		 workloadForm.setCombatVeteran("");
    		 workloadForm.setAgentOrange("");
    		 workloadForm.setIonizingRadiation("");
    		 workloadForm.setSwAsiaCondition("");
    		 workloadForm.setMilitarySexualTrauma("");
    		 workloadForm.setHeadNeckCancer("");
    		 workloadForm.setProject112("");
    	 }
   }

	private String otherDiagnosis(){
		setSessionAttribute(DIAGNOSIS_POPUP,"OTHER_DIAGNOSIS");
		return STRUTS_RESULT_PROBLEM_LIST;
	}

	private String loadProblemList(){
		setProblemListMap(getPatientProblemList());
		setSessionAttribute(DIAGNOSIS_POPUP,"PROBLEM_LIST");
		return STRUTS_RESULT_PROBLEM_LIST;
	}

	private String searchDianosis(){
		String searchDiagnosisName=getRequest().getParameter("searchDiagnosis");
		if(searchDiagnosisName.trim()=="" || searchDiagnosisName.trim().length()<2){
			addFieldError("diagnosisError1", WorkloadUtil.getDSSErrorMessage(getWorkloadProperties(), SmsServiceMessages.DIAGNOSIS_ERR1,null));
			setSessionAttribute(DIAGNOSIS_POPUP,"OTHER_DIAGNOSIS");
			return STRUTS_RESULT_PROBLEM_LIST;
		}
		setSearchDiagnosis(searchDiagnosisName);
		setDiagnosisMap(getDiagnosis(searchDiagnosisName));
		setSessionAttribute(DIAGNOSIS_POPUP,"OTHER_DIAGNOSIS");
		return STRUTS_RESULT_PROBLEM_LIST;
	}

	private Map<String, String> getDSSUnitsBySMClinic(){
		Map<String,String> dssUnitsMap = new HashMap<String,String>();
		try{
		LocationDssUnitsDTO locationDSSUnits = adminService.getDSSUnitsByClinicAndStation(((Clinician)getCurrentUser()).getStationNo(),getSelectedClinicIen(), ((Clinician)getCurrentUser()).getDuz(),getWorkloadType());
		TiuNotePreview notePreview = (TiuNotePreview) getRequest().getSession().getAttribute("notePreview");
		if(locationDSSUnits.getError()!=null){
			if(log.isInfoEnabled()){
				log.info("LocationDSSUnits Error......"+locationDSSUnits.getError());
			}
		    String errMessage =  getWorkloadProperties().getWorkloadError();
			addFieldError("workloadFormError", WorkloadUtil.getDSSErrorMessage(getWorkloadProperties(), locationDSSUnits.getError(),notePreview.getClinicName()));
		}else{
			List<DSSUnit> dssUnitsList = locationDSSUnits.getDssUnits();
			if(log.isInfoEnabled()){
				log.info("User: "+getCurrentUser().getId()+"^Associated DSS units size......"+locationDSSUnits.getDssUnits().size());
			}
			for(DSSUnit dss:dssUnitsList){
				dssUnitsMap.put(dss.getDSSIEN(), dss.getDSSName());
			}
            setLocationIen(locationDSSUnits.getLocationIen());
			notePreview.setLocation(locationDSSUnits.getLocationIen()+"^"+locationDSSUnits.getLocationName());
		}
		}catch(Exception e1)
		{
			if(log.isErrorEnabled()){
				log.error("Error while fetching DSSUnitsBySMClinic...."+e1);
			}
			addFieldError("workloadFormError", "An Error occured while connecting to ensemble, please try agin later.");
		}
		return dssUnitsMap;
	}

	public Map getECSProceduresByDSSAndLocation() {
		TiuNotePreview notePreview = (TiuNotePreview) getRequest().getSession().getAttribute("notePreview");

		Map<String,String> procedureMap = new HashMap<String,String>();
		if(log.isInfoEnabled()){
			log.info("User:"+getCurrentUser().getId()+"^Selected DSS Unit......"+getSessionAttribute(SESSION_DSS_UNIT)+"Location Ien:"+getLocationIen());
		}

		CollectionServiceResponse<ECSProcedure> response = adminService.getECSProcedures(((Clinician)getCurrentUser()).getStationNo(), notePreview.getLocation(), getSessionAttribute(SESSION_DSS_UNIT));
		Collection<ECSProcedure> searchResult = response.getCollection();
		
		if(handleMessages(response)){
			return procedureMap;
		}

		if(searchResult!=null && !searchResult.isEmpty()){
			for(ECSProcedure procedure : searchResult) {
				StringBuffer procedureName = new StringBuffer(procedure.getECCode()).append(" ").append(procedure.getECDescription()).append(" [").append(procedure.getECSynonym()).append("]");
				procedureMap.put(procedure.getECIEN(), procedureName.toString());
			}
		}
		return getSortedMap(procedureMap);
	}


	private Map<String, String> getPatientEligibility(){
		Map<String,String> patientEligibilityMap = new HashMap<String,String>();
		try
		{
			
			Long patientId = getPatientId();
			if(log.isInfoEnabled()){
				log.info("GetPatientEligibility->User:"+getCurrentUser().getId()+"^Selected Procedure......"+getSessionAttribute(SESSION_PROCEDURE)+"^PatientId"+patientId);
			}


			PatientEligibilityClassifications patientEligibility = adminService.getPatientEligibilityAndClassification(((Clinician)getCurrentUser()).getStationNo(),getDssIen(), patientId);
			if(patientEligibility.getError()!=null){
				addActionError(patientEligibility.getError());
			}else{
				List<PatientEligibility> patientEligibilitys = patientEligibility.getPatientEligibilities();
				if(log.isInfoEnabled()){
					log.info("User:"+getCurrentUser().getId()+"^Patient Id:"+patientId+"^Patient Eligibilities size..."+patientEligibilitys.size());
				}
				for(PatientEligibility eligibility:patientEligibilitys){
					patientEligibilityMap.put(eligibility.getEligCodeIEN(), eligibility.getEligDescription());
				}
				setDefaultEligibility(patientEligibility.getPrimaryEligibility());
			}
			getSession().setAttribute(SESSION_PATIENT_CLASSIFICATION,patientEligibility.getPatientClassification());
		}catch(Exception e2){
			if(log.isErrorEnabled()){
				log.error("Error in getPatientEligibility()...."+e2);
			}
		}

		return getSortedMap(patientEligibilityMap);
	}



	private Map getPatientProblemList(){
		Map problemList =  new HashMap();
		try
		{
			Long patientId = getPatientId();

			CollectionServiceResponse<Diagnosis> response = adminService.getPatientProblems(((Clinician)getCurrentUser()).getStationNo(),patientId);
			Collection<Diagnosis> searchResult = response.getCollection();
			if(log.isInfoEnabled()){
				log.info("User:"+getCurrentUser().getId()+"^PatientId:"+patientId+"^ProblemList size:"+searchResult.size());
			}

			if(handleMessages(response)){
				addActionError("Error while fetching Problem List...");
			}else{
				StringBuilder strBuilder=new StringBuilder();

				for(Diagnosis diag:searchResult){
					if((diag.getDiagnosisCode().indexOf("^I10")>0) && !diag.getDiagnosisCode().equals("R69.^I10")){
						strBuilder.append(WorkloadUtil.getIen(diag.getDiagnosisCode())).append(" ").append(diag.getDiagnosisDescription());
						problemList.put(diag.getDiagnosisIEN(), strBuilder.toString());
						strBuilder.setLength(0);
					}
				}
				
				if(getSessionAttribute(SESSION_PRIMARY_DIAGNOSIS)!=null && problemList.containsKey(WorkloadUtil.getIen(getSessionAttribute(SESSION_PRIMARY_DIAGNOSIS)))) problemList.remove(WorkloadUtil.getIen(getSessionAttribute(SESSION_PRIMARY_DIAGNOSIS)));
				if(getSessionAttribute(SESSION_SECONDARY_DIAGNOSIS1)!=null && problemList.containsKey(WorkloadUtil.getIen(getSessionAttribute(SESSION_SECONDARY_DIAGNOSIS1)))) problemList.remove(WorkloadUtil.getIen(getSessionAttribute(SESSION_SECONDARY_DIAGNOSIS1)));
				if(getSessionAttribute(SESSION_SECONDARY_DIAGNOSIS2)!=null && problemList.containsKey(WorkloadUtil.getIen(getSessionAttribute(SESSION_SECONDARY_DIAGNOSIS2)))) problemList.remove(WorkloadUtil.getIen(getSessionAttribute(SESSION_SECONDARY_DIAGNOSIS2)));
				if(getSessionAttribute(SESSION_SECONDARY_DIAGNOSIS3)!=null && problemList.containsKey(WorkloadUtil.getIen(getSessionAttribute(SESSION_SECONDARY_DIAGNOSIS3)))) problemList.remove(WorkloadUtil.getIen(getSessionAttribute(SESSION_SECONDARY_DIAGNOSIS3)));
				if(getSessionAttribute(SESSION_SECONDARY_DIAGNOSIS4)!=null && problemList.containsKey(WorkloadUtil.getIen(getSessionAttribute(SESSION_SECONDARY_DIAGNOSIS4)))) problemList.remove(WorkloadUtil.getIen(getSessionAttribute(SESSION_SECONDARY_DIAGNOSIS4)));
				setSessionAttributeMap(SESSION_PROBLEM_LIST_MAP, problemList);
			}
		}catch(Exception e3){
			if(log.isErrorEnabled()){
				log.error("Error inside getPatientProblemList...."+e3);
			}
		}

		return getSortedMap(problemList);
	}

	private Map getDiagnosis(String searchDiagnosisName){
		Map diagnosisMap =  new HashMap();
		try
		{
			if(log.isInfoEnabled()){
				log.info("User:"+getCurrentUser().getId()+"^Search Diagnosis..."+searchDiagnosisName);
			}
			DiagnosisDTO response = adminService.getDiagnosis(((Clinician)getCurrentUser()).getStationNo(),searchDiagnosisName).getPayload();
			if(response!=null && response.getDiagnosisError()!=null){
				if(response.getDiagnosisError().equals(SmsServiceMessages.DIAGNOSIS_ERR1)){
					addFieldError("diagnosisError2", WorkloadUtil.getDSSErrorMessage(getWorkloadProperties(), SmsServiceMessages.DIAGNOSIS_ERR2,null));
					addFieldError("diagnosisError3", WorkloadUtil.getDSSErrorMessage(getWorkloadProperties(), SmsServiceMessages.DIAGNOSIS_ERR3,null));
					return diagnosisMap;
				}
				else if(response.getDiagnosisError().equals(SmsServiceMessages.DIAGNOSIS_ERR4)){
					addFieldError("diagnosisError1", WorkloadUtil.getDSSErrorMessage(getWorkloadProperties(), SmsServiceMessages.DIAGNOSIS_ERR4,null));
					return diagnosisMap;
				}
			}
			
			if(response!=null && response.getDiagnosis()!=null){
				List<Diagnosis> searchResult = response.getDiagnosis();
				if(log.isInfoEnabled()){
					log.info("User:"+getCurrentUser().getId()+"^Diagnosis results size..."+searchResult.size());
				}
				StringBuilder strBuilder=new StringBuilder();
				for(Diagnosis diag:searchResult){
					//if((diag.getDiagnosisCode().indexOf("^I10")>0) && !diag.getDiagnosisCode().equals("R69.^I10")){
						strBuilder.append(WorkloadUtil.getIen(diag.getDiagnosisCode())).append(" ").append(diag.getDiagnosisDescription());
						diagnosisMap.put(diag.getDiagnosisIEN(), strBuilder.toString());
						strBuilder.setLength(0);
					//}
				}
			}
			if(getSessionAttribute(SESSION_PRIMARY_DIAGNOSIS)!=null && diagnosisMap.containsKey(WorkloadUtil.getIen(getSessionAttribute(SESSION_PRIMARY_DIAGNOSIS)))) diagnosisMap.remove(WorkloadUtil.getIen(getSessionAttribute(SESSION_PRIMARY_DIAGNOSIS)));
			if(getSessionAttribute(SESSION_SECONDARY_DIAGNOSIS1)!=null && diagnosisMap.containsKey(WorkloadUtil.getIen(getSessionAttribute(SESSION_SECONDARY_DIAGNOSIS1)))) diagnosisMap.remove(WorkloadUtil.getIen(getSessionAttribute(SESSION_SECONDARY_DIAGNOSIS1)));
			if(getSessionAttribute(SESSION_SECONDARY_DIAGNOSIS2)!=null && diagnosisMap.containsKey(WorkloadUtil.getIen(getSessionAttribute(SESSION_SECONDARY_DIAGNOSIS2)))) diagnosisMap.remove(WorkloadUtil.getIen(getSessionAttribute(SESSION_SECONDARY_DIAGNOSIS2)));
			if(getSessionAttribute(SESSION_SECONDARY_DIAGNOSIS3)!=null && diagnosisMap.containsKey(WorkloadUtil.getIen(getSessionAttribute(SESSION_SECONDARY_DIAGNOSIS3)))) diagnosisMap.remove(WorkloadUtil.getIen(getSessionAttribute(SESSION_SECONDARY_DIAGNOSIS3)));
			if(getSessionAttribute(SESSION_SECONDARY_DIAGNOSIS4)!=null && diagnosisMap.containsKey(WorkloadUtil.getIen(getSessionAttribute(SESSION_SECONDARY_DIAGNOSIS4)))) diagnosisMap.remove(WorkloadUtil.getIen(getSessionAttribute(SESSION_SECONDARY_DIAGNOSIS4)));
			setSessionAttributeMap(SESSION_DIAGNOSIS_MAP, diagnosisMap);
		}catch(Exception e3){
			if(log.isErrorEnabled()){
				log.error("Error inside getDiagnosis(searchDiagnosisName)...."+e3);
				e3.printStackTrace();
			}
		}

		return getSortedMap(diagnosisMap);
	}




	private void setSelectedProblemList(){
		String selectdProblemListIen= getRequest().getParameter("problemListIen");
		String whichDiagnosis = getSessionAttribute(WHICH_DIAGNOSIS);

		Map problemMap = getSessionAttributeMap(SESSION_PROBLEM_LIST_MAP);
		String selectdProblemListName = problemMap.get(selectdProblemListIen).toString();


		if(whichDiagnosis.equalsIgnoreCase(PRIMARY)){
			setSessionAttribute(SESSION_PRIMARY_DIAGNOSIS,WorkloadUtil.getNameWithIen(selectdProblemListIen,selectdProblemListName));
		}
		else if(whichDiagnosis.equalsIgnoreCase(SECONDARY1)){
			setSessionAttribute(SESSION_SECONDARY_DIAGNOSIS1,WorkloadUtil.getNameWithIen(selectdProblemListIen,selectdProblemListName));
		}
		else if(whichDiagnosis.equalsIgnoreCase(SECONDARY2)){
			setSessionAttribute(SESSION_SECONDARY_DIAGNOSIS2,WorkloadUtil.getNameWithIen(selectdProblemListIen,selectdProblemListName));
		}
		else if(whichDiagnosis.equalsIgnoreCase(SECONDARY3)){
			setSessionAttribute(SESSION_SECONDARY_DIAGNOSIS3,WorkloadUtil.getNameWithIen(selectdProblemListIen,selectdProblemListName));
		}
		else if(whichDiagnosis.equalsIgnoreCase(SECONDARY4)){
			setSessionAttribute(SESSION_SECONDARY_DIAGNOSIS4,WorkloadUtil.getNameWithIen(selectdProblemListIen,selectdProblemListName));
		}

		removeSessionAttribute(SESSION_PROBLEM_LIST_MAP);
		removeSessionAttribute(WHICH_DIAGNOSIS);
	}

	private void setSelectedDiagnosis(){

		String selectedDiagnosisIen= getRequest().getParameter("diagnosisIen");
		String whichDiagnosis = getSessionAttribute(WHICH_DIAGNOSIS);

		String selectedDiagnosisName ="";
		if(getSessionAttributeMap(SESSION_DIAGNOSIS_MAP)!=null){
			selectedDiagnosisName = ((Map)getSessionAttributeMap(SESSION_DIAGNOSIS_MAP)).get(selectedDiagnosisIen).toString();
		}

		if(whichDiagnosis.equalsIgnoreCase(PRIMARY)){
			setSessionAttribute(SESSION_PRIMARY_DIAGNOSIS,WorkloadUtil.getNameWithIen(selectedDiagnosisIen,selectedDiagnosisName));
		}
		else if(whichDiagnosis.equalsIgnoreCase(SECONDARY1)){
			setSessionAttribute(SESSION_SECONDARY_DIAGNOSIS1,WorkloadUtil.getNameWithIen(selectedDiagnosisIen,selectedDiagnosisName));
		}
		else if(whichDiagnosis.equalsIgnoreCase(SECONDARY2)){
			setSessionAttribute(SESSION_SECONDARY_DIAGNOSIS2,WorkloadUtil.getNameWithIen(selectedDiagnosisIen,selectedDiagnosisName));
		}
		else if(whichDiagnosis.equalsIgnoreCase(SECONDARY3)){
			setSessionAttribute(SESSION_SECONDARY_DIAGNOSIS3,WorkloadUtil.getNameWithIen(selectedDiagnosisIen,selectedDiagnosisName));
		}
		else if(whichDiagnosis.equalsIgnoreCase(SECONDARY4)){
			setSessionAttribute(SESSION_SECONDARY_DIAGNOSIS4,WorkloadUtil.getNameWithIen(selectedDiagnosisIen,selectedDiagnosisName));
		}
		removeSessionAttribute(SESSION_DIAGNOSIS_MAP);
		removeSessionAttribute(WHICH_DIAGNOSIS);
	}



    private String notePreview(Message message, Clinician c){

		getRequest().getSession().setAttribute("notePreview", null);
		ServiceResponse<TiuNotePreview> response = getTiuNoteService().getNotePreviewSMWeb(message.getThread(), c);
		Long triageGroupId = message.getThread().getMailGroup().getId();
		SMClinicsTriageMap clinicsTriageMap = getTriageGroupDao().getActiveSMClinicByTriageGroup(triageGroupId);

		if(handleMessages(response)){
			getRequest().setAttribute("TIU_ERRORS", Boolean.TRUE);
			}
		TiuNotePreview preview = response.getPayload();
		preview.setCurrentMessageId(message.getId());
		if(preview!=null){
			preview.setClinicName(DEFAULT_SM_CLINIC);
			preview.setCprsTitle(DEFAULT_CPRS_NOTE_TITLE);

			if(clinicsTriageMap!=null && clinicsTriageMap.getSmClinicName()!=null){
				preview.setClinicName(clinicsTriageMap.getSmClinicName());
				preview.setClinicIen(clinicsTriageMap.getSmClinicIen());
			}

			if(clinicsTriageMap!=null && clinicsTriageMap.getSmClinicNameCPRSTitle()!=null)
				preview.setCprsTitle(clinicsTriageMap.getSmClinicNameCPRSTitle());
			preview.setVistAPatch11Status(getWorkloadProperties().getVistAPatch11Status());
			preview.setVistAPatch11Fields(getWorkloadProperties().getVistAPatch11Fields());
		}
		getRequest().getSession().setAttribute("notePreview", preview);

		return STRUTS_RESULT_SAVE;
}
    public String selectedClinicAndTitle(){
    	populateClincsAndTitles();
    	setDefaultClinic(getClinicIen());
    	setDefaultTitle(getNoteTitle());
    	getSession().setAttribute(SESSION_SELECTED_MESSAGES_IN_THREAD,getSelectedMessages());
    	if(getClinicIen().equals("-1")){
			addFieldError("clinicError","You must select a SM Clinic.");
			setDefaultClinic("-1");
			return STRUTS_RESULT_CHANGECLINIC;
    	}
    	else if(getNoteTitle().equals("-1")){
			addFieldError("clinicError","You must select a CPRS Progress Note Title.");
			setDefaultTitle("-1");
			return STRUTS_RESULT_CHANGECLINIC;
    	}
    	else{
    		return displayClinicAndTitle(); // Go to Display existing clinic and titles page.
    	}

    }

    public String displayClinicAndTitle(){
    	TiuNotePreview preview = (TiuNotePreview)getRequest().getSession().getAttribute("notePreview");
    	preview.setClinicIen(getClinicIen());
    	preview.setCprsTitle(getNoteTitle());
    	List<Object[]> providerClinicsList = null;
    	if(getRequest().getSession().getAttribute("providerClinicsList")!=null)
    		providerClinicsList = (List<Object[]>)getRequest().getSession().getAttribute("providerClinicsList");
    	for(Object[] object : providerClinicsList)
		{
    		if(object[0].equals(getClinicIen())){
    			preview.setClinicName(object[1].toString());
    			break;
    		}
		}
    	getRequest().getSession().setAttribute("notePreview", preview);
    	getRequest().getSession().setAttribute("providerClinicsList",null);
    	return STRUTS_RESULT_SAVE;
    }

    public void populateClincsAndTitles(){
    	Clinician clinician = ((Clinician)getCurrentUser());
		Message currentMessage = (Message) getRequest().getSession().getAttribute(CURRENT_MESSAGE);

    	List<Object[]> providerClinicsList = getTriageGroupDao().getAssociatedSMClinicsByClinicianAndStation(new Long(clinician.getStationNo()),clinician.getId());
		getRequest().getSession().setAttribute("providerClinicsList",providerClinicsList);
		HashMap clinicsList= new HashMap();
		for(Object[] object : providerClinicsList)
		{
			clinicsList.put(object[0], object[1].toString().trim());
		}
		setProviderClinics(getSortedMap(clinicsList));
		setCprsTitles(getCPRSTitleFromVistA());
    }

	public String changeClinicAndTitles(){
		getSession().setAttribute(SESSION_SELECTED_MESSAGES_IN_THREAD,getSelectedMessages());
    	Clinician clinician = ((Clinician)getCurrentUser());
		Message currentMessage = (Message) getRequest().getSession().getAttribute(CURRENT_MESSAGE);

		populateClincsAndTitles();
		return changeClinicWithNotePreview(currentMessage, clinician);
	}

	private String changeClinicWithNotePreview(Message message, Clinician c){

		TiuNotePreview preview = (TiuNotePreview)getRequest().getSession().getAttribute("notePreview");
		if(preview.getClinicIen()!=null){
			setDefaultClinic(preview.getClinicIen().trim());
		}
		if(preview.getCprsTitle()!=null && !preview.getCprsTitle().equalsIgnoreCase(DEFAULT_CPRS_NOTE_TITLE)){
			setDefaultTitle(preview.getCprsTitle().trim());
		}

		return STRUTS_RESULT_CHANGECLINIC;
	}


	private TreeSet<String> getCPRSTitleFromVistA(){
		String documentClassName = null;
		if(getWorkloadProperties()!=null){
			documentClassName = getWorkloadProperties().getTiuDocumentClassName();
		}
		TreeSet<String> tiuCPRSTitleSet = new TreeSet();
		Clinician clinician = ((Clinician)getCurrentUser());
		CollectionServiceResponse<SMNoteTitle> response = adminService.getCPRSTIUTitles(clinician.getStationNo(),documentClassName);
		Collection<SMNoteTitle> searchResult = response.getCollection();
		if(searchResult!=null || !searchResult.isEmpty()){
			for(SMNoteTitle title : searchResult) {
				tiuCPRSTitleSet.add(title.getTIUTitle());
			}
		}
		return tiuCPRSTitleSet;
	}

	private String saveHistoricalECS(){
		if(getSessionAttribute(SESSION_DSS_UNIT)==null){
			addFieldError("workloadFormError","Please select a DSS Unit.");
			changeDSSUnit();
			return STRUTS_RESULT_WORKLOAD;
		}

		if(getSessionAttribute(SESSION_PROCEDURE)==null){
				 addFieldError("workloadFormError","Please select a Procedure Name.");
				 changeProcedure();
				 return STRUTS_RESULT_WORKLOAD;
		}

		//String[] providerIds = getRequest().getParameterValues("workloadForm.providerId");

		if(getSessionAttribute(SESSION_PRIMARY_PROVIDER)==null){
			addFieldError("workloadFormError","Please select a Primary Provider." );
			return STRUTS_RESULT_WORKLOAD;
		}

		SMWorkloadHistorical workloadHistorical = new SMWorkloadHistorical();
		workloadHistorical.setCaptureType(WorkloadCaptureTypeEnum.HISTORICAL_NOTE);
		workloadHistorical.setThreadId(getCurrentMessage().getThread().getId());

		Long patientId = getPatientId();

		workloadHistorical.setPatientId(patientId);

		TiuNotePreview preview = (TiuNotePreview)getSession().getAttribute("notePreview");
		workloadHistorical.setSmClinic(WorkloadUtil.getNameWithIen(preview.getClinicIen(),preview.getClinicName()));
		workloadHistorical.setNoteTitle(preview.getCprsTitle());
		workloadHistorical.setStationNumber(new Long(((Clinician)getCurrentUser()).getStationNo()));
		workloadHistorical.setProcedureDate(preview.getProcedureDateTime());
		workloadHistorical.setDssUnit(getSessionAttribute(SESSION_DSS_UNIT));
		workloadHistorical.setProcedureName(getSessionAttribute(SESSION_PROCEDURE));

		workloadHistorical.setLocation(preview.getLocation());
		workloadHistorical.setUserId(getCurrentUser().getId());
		String[] secondaryProviders = getRequest().getParameterValues("workloadForm.providerId");

		workloadHistorical.setProviders(WorkloadUtil.getProvidersWithDelimiter(WorkloadUtil.getIen(getSessionAttribute(SESSION_PRIMARY_PROVIDER)),secondaryProviders));

		//Call New TIU Post API and get conversationId, visitIen and save the ECS to local SMS
		ServiceResponse<SMWorkloadHistorical> workloadResponse = getTiuNoteService().createWorkload(workloadHistorical);
		removeAllSessionAttribute();
		if(workloadResponse.getPayload()!=null && workloadResponse.getPayload().getStatus().equalsIgnoreCase("OK")){
			if(workloadResponse.getPayload().getVisitIen()!=null){
				TiuNotePreview notePreview = (TiuNotePreview)getSession().getAttribute("notePreview");
				notePreview.setVisitIen(workloadResponse.getPayload().getVisitIen());
				getSession().setAttribute("notePreview",notePreview);
			}
			addFieldError("wlc_error",SmsServiceMessages.HISTORICAL_SAVE_SUCCESS);
			return STRUTS_RESULT_WLC_SUCCESS;
		}else{
			addFieldError("wlc_error",workloadResponse.getPayload().getEcsError());
			return STRUTS_RESULT_WLC_ERROR;
		}
	}


	private String saveWorkloadECS(){

			if(getSessionAttribute(SESSION_DSS_UNIT)==null){
				addFieldError("workloadFormError","Please select a DSS Unit.");
				changeDSSUnit();
				return STRUTS_RESULT_WORKLOAD;
			}

			if(getSessionAttribute(SESSION_PROCEDURE)==null){
				 addFieldError("workloadFormError","Please select a Procedure Name.");
				 changeProcedure();
				 return STRUTS_RESULT_WORKLOAD;
			}

			if(getSessionAttribute(SESSION_ELIGIBILITY)==null){
				 addFieldError("workloadFormError","Please select a Eligibility Code.");
				 changeEligibility();
				 return STRUTS_RESULT_WORKLOAD;
			}

			PatientClassifications classifications = (PatientClassifications)getSession().getAttribute(SESSION_PATIENT_CLASSIFICATION);
			String serviceConnected=getRequest().getParameter("workloadForm.serviceConnected");
			if(classifications.getSCCondition().equals("E"))
			{
				if(serviceConnected==null){

					 addFieldError("workloadFormError","The Service Connected value is required." );
					 return STRUTS_RESULT_WORKLOAD;
				}

				if(serviceConnected!=null && serviceConnected.equalsIgnoreCase("0"))
				{
					String agentOrange=getRequest().getParameter("workloadForm.agentOrange");
					if(agentOrange==null || agentOrange==""){
						addFieldError("workloadFormError","The Agent Orange value is required." );
						return STRUTS_RESULT_WORKLOAD;
					}
					String ionizingRadiation=getRequest().getParameter("workloadForm.ionizingRadiation");
				    if(ionizingRadiation==null || ionizingRadiation==""){
						addFieldError("workloadFormError","The Ionizing Radiation value is required." );
						return STRUTS_RESULT_WORKLOAD;
					}

				    String swAsiaCondition=getRequest().getParameter("workloadForm.swAsiaCondition");
					if(workloadForm.getSwAsiaCondition()==null || workloadForm.getSwAsiaCondition()==""){
						addFieldError("workloadFormError","The SW Asia Conditions value is required." );
						return STRUTS_RESULT_WORKLOAD;
					}
				}

			}

			if(classifications.getMilitarySexualTrauma().equals("E")){
				String militarySexualTrauma=getRequest().getParameter("workloadForm.militarySexualTrauma");
				if(militarySexualTrauma==null || militarySexualTrauma==""){
					addFieldError("workloadFormError","The Military Sexual Trauma value is required." );
					return STRUTS_RESULT_WORKLOAD;
				}
			}

			if(classifications.getHeadNeckCancer().equals("E")){
				String headNeckCancer=getRequest().getParameter("workloadForm.headNeckCancer");
				if(headNeckCancer==null || headNeckCancer==""){
					addFieldError("workloadFormError","The Head/Neck Cancer value is required." );
					return STRUTS_RESULT_WORKLOAD;
				}
			}

			if(classifications.getProject112SHAD().equals("E")){
				String projectShad=getRequest().getParameter("workloadForm.project112");
				if(projectShad==null || projectShad==""){
					addFieldError("workloadFormError","The Project 112/SHAD value is required." );
					return STRUTS_RESULT_WORKLOAD;
				}
			}
			SMWorkloadHistorical workloadHistorical = new SMWorkloadHistorical();
			workloadHistorical.setCaptureType(WorkloadCaptureTypeEnum.WORKLOAD_CREDIT);
			workloadHistorical.setThreadId(getCurrentMessage().getThread().getId());

			Long patientId = getPatientId();
			
		    workloadHistorical.setPatientId(patientId);

			TiuNotePreview preview = (TiuNotePreview)getSession().getAttribute("notePreview");
			workloadHistorical.setSmClinic(WorkloadUtil.getNameWithIen(preview.getClinicIen(),preview.getClinicName()));
			workloadHistorical.setNoteTitle(preview.getCprsTitle());
			workloadHistorical.setStationNumber(new Long(((Clinician)getCurrentUser()).getStationNo()));
			workloadHistorical.setProcedureDate(preview.getProcedureDateTime());
			workloadHistorical.setDssUnit(getSessionAttribute(SESSION_DSS_UNIT));
			workloadHistorical.setProcedureName(getSessionAttribute(SESSION_PROCEDURE));
			workloadHistorical.setEligibilityCode(getSessionAttribute(SESSION_ELIGIBILITY));

			PatientClassifications patClass = new PatientClassifications();
			patClass.setInpatientOutpatientStatus(classifications.getInpatientOutpatientStatus());
			if(serviceConnected!=null)
			{
				if(serviceConnected.equals("1")) patClass.setSCCondition("Y");
				else patClass.setSCCondition("N");
			}

			if(getRequest().getParameter("workloadForm.combatVeteran")!=null){
				if(workloadForm.getCombatVeteran().equals("1")) patClass.setCombatVet("Y");
				else patClass.setCombatVet("N");
			}

			if(getRequest().getParameter("workloadForm.agentOrange")!=null) {
				if(workloadForm.getAgentOrange().equals("1")) patClass.setAgentOrange("Y");
				else  patClass.setAgentOrange("N");
			}

			if(getRequest().getParameter("workloadForm.ionizingRadiation")!=null ) {
				if(workloadForm.getIonizingRadiation().equals("1")) patClass.setIonizingRadiation("Y");
				else  patClass.setIonizingRadiation("N");

			}

			if(getRequest().getParameter("workloadForm.swAsiaCondition")!=null ) {
				if(workloadForm.getSwAsiaCondition().equals("1")) patClass.setEnvironmentalContaminants("Y");
				else  patClass.setEnvironmentalContaminants("N");
			}

			if(getRequest().getParameter("workloadForm.militarySexualTrauma")!=null ){
				if(workloadForm.getMilitarySexualTrauma().equals("1")) patClass.setMilitarySexualTrauma("Y");
				else  patClass.setMilitarySexualTrauma("N");
			}

			if(getRequest().getParameter("workloadForm.headNeckCancer")!=null ){
				if(workloadForm.getHeadNeckCancer().equals("1")) patClass.setHeadNeckCancer("Y");
				else   patClass.setHeadNeckCancer("N");
			}

			if(getRequest().getParameter("workloadForm.project112")!=null ){
				if(workloadForm.getProject112().equals("1")) patClass.setProject112SHAD("Y");
				else  patClass.setProject112SHAD("N");
			}

			if(getSessionAttribute(SESSION_PRIMARY_PROVIDER)==null){
				addFieldError("workloadFormError","Please select a Primary Provider." );
				return STRUTS_RESULT_WORKLOAD;
			}

			workloadHistorical.setPatientClass(patClass);
			workloadHistorical.setPatientStatus(classifications.getInpatientOutpatientStatus());
			String[] secondaryProviders = getRequest().getParameterValues("workloadForm.providerId");
			workloadHistorical.setProviders(WorkloadUtil.getProvidersWithDelimiter(WorkloadUtil.getIen(getSessionAttribute(SESSION_PRIMARY_PROVIDER)),secondaryProviders));
			workloadHistorical.setDiagnosis(getDiagnosis());
			workloadHistorical.setLocation(preview.getLocation());
			workloadHistorical.setUserId(getCurrentUser().getId());

			// Call New TIU Post API and get conversationId, visitIen and save the ECS to local SMS
			ServiceResponse<SMWorkloadHistorical> workloadResponse = getTiuNoteService().createWorkload(workloadHistorical);
			removeAllSessionAttribute();
			if(workloadResponse.getPayload()!=null){
				if(workloadResponse.getPayload().getVisitIen()!=null){
					TiuNotePreview notePreview = (TiuNotePreview)getSession().getAttribute("notePreview");
					notePreview.setVisitIen(workloadResponse.getPayload().getVisitIen().toString());
					getSession().setAttribute("notePreview",notePreview);
				}
				if(workloadResponse.getPayload().getStatus().equalsIgnoreCase(("OK")) && workloadResponse.getPayload().getEcsIen()!=null){
					addFieldError("wlc_error",SmsServiceMessages.WORKLOAD_SAVE_SUCCESS);
					return STRUTS_RESULT_WLC_SUCCESS;
				}else{
					addFieldError("wlc_error",workloadResponse.getPayload().getEcsError());
					return STRUTS_RESULT_WLC_ERROR;
				}
			}else{
				addFieldError("wlc_error",workloadResponse.getPayload().getEcsError());
				return STRUTS_RESULT_WLC_ERROR;
			}
	}


	private String getDiagnosis(){
		StringBuilder diagBuilder = new StringBuilder((WorkloadUtil.getIen(getSessionAttribute(SESSION_PRIMARY_DIAGNOSIS))));
		if(getSessionAttribute(SESSION_SECONDARY_DIAGNOSIS1)!=null) diagBuilder.append(";").append((WorkloadUtil.getIen(getSessionAttribute(SESSION_SECONDARY_DIAGNOSIS1))));
		if(getSessionAttribute(SESSION_SECONDARY_DIAGNOSIS2)!=null) diagBuilder.append(";").append((WorkloadUtil.getIen(getSessionAttribute(SESSION_SECONDARY_DIAGNOSIS2))));
		if(getSessionAttribute(SESSION_SECONDARY_DIAGNOSIS3)!=null) diagBuilder.append(";").append((WorkloadUtil.getIen(getSessionAttribute(SESSION_SECONDARY_DIAGNOSIS3))));
		if(getSessionAttribute(SESSION_SECONDARY_DIAGNOSIS4)!=null) diagBuilder.append(";").append((WorkloadUtil.getIen(getSessionAttribute(SESSION_SECONDARY_DIAGNOSIS4))));
		return diagBuilder.toString();
	}
	
	private Long getPatientId(){
		Long patientId=null;
		if(getCurrentMessage().getSenderType().equals(ParticipantTypeEnum.PATIENT)){
			patientId = getCurrentMessage().getSenderId(); 
		}else if(getCurrentMessage().getSenderType().equals(ParticipantTypeEnum.CLINICIAN)){
			patientId = getCurrentMessage().getRecipientId();
		}
		return patientId;
	}

	public String getChangeClinic() {
		return changeClinic;
	}
	public Map getProcedureNamesMap() {
		return procedureNamesMap;
	}

	public void setProcedureNamesMap(Map procedureNamesMap) {
		this.procedureNamesMap = procedureNamesMap;
	}

	public String getDssUnitSelect() {
		return dssUnitSelect;
	}

	public String getChangeProcedure() {
		return changeProcedure;
	}

	public void setChangeProcedure(String changeProcedure) {
		this.changeProcedure = changeProcedure;
	}

	public String getProcedureSelect() {
		return procedureSelect;
	}

	public String getEligibilitySelect() {
		return eligibilitySelect;
	}

	public void setEligibilitySelect(String eligibilitySelect) {
		this.eligibilitySelect = eligibilitySelect;
	}

	public void setProcedureSelect(String procedureSelect) {
		this.procedureSelect = procedureSelect;
	}

	public void setDssUnitSelect(String dssUnitSelect) {
		this.dssUnitSelect = dssUnitSelect;
	}

	public Map getDssUnits() {
		return dssUnits;
	}

	public void setDssUnits(Map dssUnits) {
		this.dssUnits = dssUnits;
	}

	public Map<String, String> getEligibilityMap() {
		return eligibilityMap;
	}

	public void setEligibilityMap(Map<String, String> eligibilityMap) {
		this.eligibilityMap = eligibilityMap;
	}

	public Map getProvidersList() {
		return providersList;
	}

	public void setProvidersList(Map providersList) {
		this.providersList = providersList;
	}

	public Map getProviderClinics() {
		return providerClinics;
	}

	public void setProviderClinics(Map providerClinics) {
		this.providerClinics = providerClinics;
	}

	public void setChangeClinic(String changeClinic) {
		this.changeClinic = changeClinic;
	}

	public Collection getCprsTitles() {
		return cprsTitles;
	}

	public void setCprsTitles(Collection cprsTitles) {
		this.cprsTitles = cprsTitles;
	}

	public String getDefaultClinic() {
		return defaultClinic;
	}

	public String getClinicIen() {
		return clinicIen;
	}

	public String getLocationIen() {
		return locationIen;
	}

	public void setLocationIen(String locationIen) {
		this.locationIen = locationIen;
	}


	public void setClinicIen(String clinicIen) {
		this.clinicIen = clinicIen;
	}

	public  String getNoteTitle() {
		return noteTitle;
	}

	public  void setNoteTitle(String noteTitle) {
		this.noteTitle = noteTitle;
	}

	public void setDefaultClinic(String defaultClinic) {
		this.defaultClinic = defaultClinic;
	}

	public  String getSelectClinicAndTitle() {
		return selectClinicAndTitle;
	}

	public  void setSelectClinicAndTitle(String selectClinicAndTitle) {
		this.selectClinicAndTitle = selectClinicAndTitle;
	}

	public String getCancelClinicAndTitle() {
		return cancelClinicAndTitle;
	}

	public  void setCancelClinicAndTitle(String cancelClinicAndTitle) {
		this.cancelClinicAndTitle = cancelClinicAndTitle;
	}

	public String getDefaultTitle() {
		return defaultTitle;
	}

	public void setDefaultTitle(String defaultTitle) {
		this.defaultTitle = defaultTitle;
	}


	public void setWorkloadForm(WorkloadForm workloadForm){
		this.workloadForm = workloadForm;
	}

	public WorkloadForm getWorkloadForm(){
		return workloadForm;
	}

	private void removeSessionAttribute(String sessionAttribute){
		getSession().removeAttribute(sessionAttribute);
	}

	private void setSessionAttributeMap(String sessionAttribute, Map sessionMap){
		getSession().setAttribute(sessionAttribute, sessionMap);
	}

	private void setSessionAttribute(String attribute, String value){
		getSession().setAttribute(attribute, value);
	}

	private String getSessionAttribute(String sessionAttribute){
		if(getSession().getAttribute(sessionAttribute)!=null){
			return getSession().getAttribute(sessionAttribute).toString();
		}
		return null;
	}

	private Map getSessionAttributeMap(String sessionAttribute){
		if(getSession().getAttribute(sessionAttribute)!=null){
			return (Map)getSession().getAttribute(sessionAttribute);
		}
		return null;
	}

	private Message getCurrentMessage(){
		return (Message) getRequest().getSession().getAttribute(CURRENT_MESSAGE);
	}

	private String getSelectedClinicIen(){
		 TiuNotePreview notePreview = (TiuNotePreview) getRequest().getSession().getAttribute("notePreview");
		 return notePreview.getClinicIen();
	}




	private String getDssIen(){
		return WorkloadUtil.getIen(getSessionAttribute(SESSION_DSS_UNIT));
	}

	public String getDefaultEligibility() {
		return defaultEligibility;
	}

	public void setDefaultEligibility(String defaultEligibility) {
		this.defaultEligibility = defaultEligibility;
	}

	public String getPrimarySelect() {
		return primarySelect;
	}

	public void setPrimarySelect(String primarySelect) {
		this.primarySelect = primarySelect;
	}

	public String getProblemList() {
		return problemList;
	}

	public void setProblemList(String problemList) {
		this.problemList = problemList;
	}

	public String getProblemListSelectSubmit() {
		return problemListSelectSubmit;
	}

	public void setProblemListSelectSubmit(String problemListSelectSubmit) {
		this.problemListSelectSubmit = problemListSelectSubmit;
	}

	public boolean getVisitRelatedTo() {
		return visitRelatedTo;
	}

	public void setVisitRelatedTo(boolean visitRelatedTo) {
		this.visitRelatedTo = visitRelatedTo;
	}

	public Map getProblemListMap() {
		return problemListMap;
	}

	public void setProblemListMap(Map problemListMap) {
		this.problemListMap = problemListMap;
	}

	public String getDiagnosisSearchSubmit() {
		return diagnosisSearchSubmit;
	}

	public void setDiagnosisSearchSubmit(String diagnosisSearchSubmit) {
		this.diagnosisSearchSubmit = diagnosisSearchSubmit;
	}

	public String getPrimarySearch() {
		return primarySearch;
	}

	public void setPrimarySearch(String primarySearch) {
		this.primarySearch = primarySearch;
	}

	public String getDianosisSelectSubmit() {
		return dianosisSelectSubmit;
	}

	public void setDianosisSelectSubmit(String dianosisSelectSubmit) {
		this.dianosisSelectSubmit = dianosisSelectSubmit;
	}
	private void removeAllSessionAttribute(){
		removeSessionAttribute(SESSION_DSS_UNIT);
		removeSessionAttribute(SESSION_PROCEDURE);
		removeSessionAttribute(SESSION_ELIGIBILITY);
		removeSessionAttribute(SESSION_PRIMARY_DIAGNOSIS);
		removeSessionAttribute(SESSION_SECONDARY_DIAGNOSIS1);
		removeSessionAttribute(SESSION_SECONDARY_DIAGNOSIS2);
		removeSessionAttribute(SESSION_SECONDARY_DIAGNOSIS3);
		removeSessionAttribute(SESSION_SECONDARY_DIAGNOSIS4);
		removeSessionAttribute(SESSION_DSS_UNITS_MAP);
		removeSessionAttribute(SESSION_PROCEDURE_MAP);
		removeSessionAttribute(SESSION_ELIGIBILITY_MAP);
		removeSessionAttribute(SESSION_PATIENT_CLASSIFICATION);
		removeSessionAttribute(SESSION_PROBLEM_LIST_MAP);
		removeSessionAttribute(SESSION_DIAGNOSIS_MAP);
		removeSessionAttribute(SESSION_PRIMARY_PROVIDER);
	}

	public Map getDiagnosisMap() {
		return diagnosisMap;
	}

	public void setDiagnosisMap(Map diagnosisMap) {
		this.diagnosisMap = diagnosisMap;
	}

	public Map<String,String> getSortedMap(Map<String,String> resultMap){
		return WorkloadUtil.sortedMap(resultMap);
	}

	public  Map sortByValue(Map unsortedMap){
	    Map sortedMap = new TreeMap(new gov.va.med.mhv.sm.web.utils.ValueComparator(unsortedMap));
	    sortedMap.putAll(unsortedMap);
	    return sortedMap;
	}

	public String getWorkloadType() {
			return workloadType;
	}

	public void setWorkloadType(String workloadType) {
			this.workloadType = workloadType;
	}

	public String getSearchDiagnosis() {
		return searchDiagnosis;
	}

	public void setSearchDiagnosis(String searchDiagnosis) {
		this.searchDiagnosis = searchDiagnosis;
	}

	public boolean isChangeDssEnabled() {
		return changeDssEnabled;
	}

	public void setChangeDssEnabled(boolean changeDssEnabled) {
		this.changeDssEnabled = changeDssEnabled;
	}

	public boolean isChangeEligibilityEnabled() {
		return changeEligibilityEnabled;
	}

	public void setChangeEligibilityEnabled(boolean changeEligibilityEnabled) {
		this.changeEligibilityEnabled = changeEligibilityEnabled;
	}
	
	public boolean isProgressNotesStatus() {
		return progressNotesStatus;
	}

	public void setProgressNotesStatus(boolean progressNotesStatus) {
		this.progressNotesStatus = progressNotesStatus;
	}
	
}
